<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class AdminController extends Controller
{
    //Show Admin Login form
    public function AhowadminLoginForm(){
        return view('auth.admin-login');

    }
    //Handle Admin Login
    public function adminLogin(Request $request){
        $credentials = $request->validate([
            'email'=>'required|email',
            'password'=>'required',
        ]);
         // Guard 'admin' use karo
        if(Auth::guard('admin')->attempt($credentials)){
            $request->session()->regenerate();
            return redirect()->intended(route('admin.dashboard'));
        }

        return back()->withErrors([
            'email'=>'Invalid credentials'
        ]);

}
 // Admin Dashboard
    public function adminDashboard() {
        return view('admin.dashboard');
    }

    // Admin Logout
    public function adminLogout(Request $request) {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('admin.login');
    }
}
